%% Script: Estrazione delle 6 matrici PHI (corretto per 6 DOF su 2 righe)
clear; clc;

filename = 'Piastra2DMasse.txt';
numModes = 15;   % Numero di modi da estrarre
numDOF = 6;      % 6 DOF totali

fid = fopen(filename, 'r');
lines = textscan(fid, '%s', 'Delimiter', '\n', 'Whitespace', '');
fclose(fid);
lines = lines{1};

phi_data = {};
modeCount = 0;

for i = 1:length(lines)
    line = strtrim(lines{i});
    if contains(line, '$EIGENVALUE') && contains(line, 'MODE')
        modeCount = modeCount + 1;
        fprintf('Lettura modo %d fatta \n', modeCount);  %flag per capire che il modo è stato effettivamente letto
        j = i + 1;
        data = [];

        while j <= length(lines) && ~contains(lines{j}, '$EIGENVALUE') && ~contains(lines{j}, '$END')
            line_j = strtrim(lines{j});

            % Riga principale (con numero di nodo)
            mainMatch = regexp(line_j, '^\s*(\d+)\s+\w+\s+([-\d.E+]+)\s+([-\d.E+]+)\s+([-\d.E+]+)', 'tokens');
            % Riga di continuazione
            contMatch = regexp(line_j, '^-CONT-\s*([-\d.E+]+)\s+([-\d.E+]+)\s+([-\d.E+]+)', 'tokens');

            if ~isempty(mainMatch)
                t = str2double(mainMatch{1});
                node = t(1);
                trans = t(2:4);
                data = [data; node trans NaN(1,3)]; % placeholder per rotazioni
            elseif ~isempty(contMatch)
                rot = str2double(contMatch{1});
                if ~isempty(data)
                    data(end, 5:7) = rot;
                end
            end
            j = j + 1;
        end

        % Controllo di consistenza (nessun NaN)
        if any(isnan(data(:, 5:7)), 'all')
            warning(' Alcuni nodi del modo %d non hanno rotazioni', modeCount);                   %varifica che tutti i nodi abbiano rotazioni
        end

        phi_data{modeCount} = data(:, 2:end); % rimuove numero di nodo
        if modeCount >= numModes
            break;
        end
    end
end



% Costruzione matrici PHI 
numNodes = size(phi_data{1}, 1);
PHI = cell(1, numDOF);

for dof = 1:numDOF
    PHI{dof} = zeros(numNodes, numModes);
    for m = 1:numModes
        PHI{dof}(:, m) = phi_data{m}(:, dof);
    end
end

% Salvataggio 
for dof = 1:numDOF
    filename_out = sprintf('PHI%d.mat', dof);
    PHI_dof = PHI{dof};
    save(filename_out, 'PHI_dof');
    fprintf('Salvata %s (%dx%d)\n', filename_out, size(PHI_dof, 1), size(PHI_dof, 2));
end

disp('Matrici PHI generate correttamente');                                     %ultimo flag per verificare che non ci siano stati problemi nella creazione delle matrici

PHI_finale=[PHI{1,1} ; PHI{1,2} ; PHI{1,3} ; PHI{1,4} ; PHI{1,5} ; PHI{1,6} ];
save('Phi_finale.mat','PHI_finale')